﻿// See https://aka.ms/new-console-template for more information


var dotnetStandard = new List<string>(){
    "1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "2.0", "2.1"
};


var dotnetImplements = new Dictionary<string, List<string>>(){
    [".NET 和.NET Core"]=new List<string>(){"1.0", "1.0", "1.0", "1.0", "1.0", "1.0", "1.0", "2.0", "3.0"},
    [".NET Framework"]=new List<string>(){"1", "4.5", "4.5", "4.5.1", "4.6", "4.6.1", "4.6.1^2", "4.6.1", "2", "4.6.1^2", "N/A3"},
    ["Mono"]=new List<string>(){"4.6", "4.6", "4.6", "4.6", "4.6", "4.6", "4.6", "5.4", "6.4"},
    ["Xamarin.iOS"]=new List<string>(){"10.0", "10.0", "10.0", "10.0", "10.0", "10.0", "10.0", "10.14", "12.16"},
    ["Xamarin.Mac"]=new List<string>(){"3.0", "3.0", "3.0", "3.0", "3.0", "3.0", "3.0", "3.8", "5.16"},
    ["Xamarin.Android"]=new List<string>(){"7.0", "7.0", "7.0", "7.0", "7.0", "7.0", "7.0", "8.0", "10.0"},
    ["通用 Windows 平台"]=new List<string>(){"10.0", "10.0", "10.0", "10.0", "10.0", "10.0.16299", "10.0.16299", "10.0.16299", "待定"},
    ["Unity"]=new List<string>(){"2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2021.2"}
};

var dotnetStandardQuery = new Dictionary<string, List<string>>();
int i=0;
foreach(var standardVersion in dotnetStandard){
    var lowerSupportImplementVersions = new List<String>();
    foreach(var dotnetImplement in dotnetImplements){
        lowerSupportImplementVersions.Add(dotnetImplement.Key+"，版本："+dotnetImplement.Value[i]);
    }
    dotnetStandardQuery.Add(standardVersion, lowerSupportImplementVersions);
    i++;
}

Console.WriteLine("以下各种.NET的实现，支持了 .NET Standard 2.1的最低版本是：");
Console.WriteLine("====");
foreach(var lowlowerSupportImplementVersion in dotnetStandardQuery["2.1"]){
    Console.WriteLine("* "+lowlowerSupportImplementVersion);
}

